﻿/********************************************************************/
/*                                                                  */
/* ADOBE SYSTEMS INCORPORATED                                       */
/* Copyright 1986 - 2010 Adobe Systems Incorporated                 */
/* All Rights Reserved                                              */
/*                                                                  */
/* NOTICE:  Adobe permits you to use, modify, and distribute this   */
/* file in accordance with the terms of the Adobe license agreement */
/* accompanying it.  If you have received this file from a source   */
/* other than Adobe, then your use, modification, or distribution   */
/* of it requires the prior written permission of Adobe.            */
/*                                                                  */
/********************************************************************/
/*
* Program Name:                                                     
 *    HierarchicalBooks.jsx- Traversal through Hierarchical Books in FrameMaker                                                    
 *                                                                   
 * General Description:                                              
 *    Traverses through the books Folder and Group hierarchy and logs the details in a text  file
 *                                                                   
 *********************************************************************/      


book=app.ActiveBook;
comp=book.FirstComponentInBook;
while(comp.ObjectValid())
{
		open(comp.Name);
		nextComp=comp.NextBookComponentInDFSOrder;
		prevComp=comp.PrevBookComponentInDFSOrder;
		compType=comp.BookComponentFileType;
		Log("BookComponent.log", "CompName-"+comp.Name);
		Log("BookComponent.log", "comp File Type-"+compType);
		Log("BookComponent.log", "Component Type(Fldr,Grp,file)-"+comp.ComponentType);
		Log("BookComponent.log", "PreviousCompName-"+prevComp.Name);
		Log("BookComponent.log", "nextCompName-"+nextComp.Name);
		Log("BookComponent.log", "---------------------------------");
		//process component here//
		comp=nextComp;
	}

function open(filename)
{
openProp = GetOpenDefaultParams()

i=GetPropIndex(openProp,Constants.FS_FileIsOldVersion)
openProp[i].propVal.ival=Constants.FV_DoOK

i=GetPropIndex(openProp,Constants.FS_FontNotFoundInCatalog)
openProp[i].propVal.ival=Constants.FV_DoOK

i=GetPropIndex(openProp,Constants.FS_FontNotFoundInDoc)
openProp[i].propVal.ival=Constants.FV_DoOK

i=GetPropIndex(openProp,Constants.FS_FileIsInUse) 
openProp[i].propVal.ival=Constants.FV_DoCancel

i=GetPropIndex(openProp,Constants.FS_AlertUserAboutFailure)
openProp[i].propVal.ival=Constants.FV_DoCancel

retParm = new PropVals()
docOpen=Open(filename,openProp,retParm);
return docOpen;
}


function Log(logFile,textLine)
{
	file=new File ("C:\\ESLog\\"+logFile);
	file.open("a+", "TEXT", "????");
	file.write(textLine+"\r");
	file.close();
	}